

-- BURST CACHE ---------------------------------------------------


local VUHDO_RAID;
local VUHDO_getUnitButtons;
local VUHDO_IN_RAID_TARGET_BUTTONS;
local VUHDO_PANEL_SETUP;
local VUHDO_BUTTON_CACHE;
local UnitPowerType = UnitPowerType;
local UnitMana = UnitMana;
local UnitManaMax = UnitManaMax;
local pairs = pairs;

local VUHDO_getHealthBar;
local VUHDO_isConfigDemoUsers;
local VUHDO_updateBouquetsForEvent;
local VUHDO_isInFight;
local sIsInverted;
function VUHDO_customManaInitBurst()
	VUHDO_RAID = VUHDO_GLOBAL["VUHDO_RAID"];
	VUHDO_getUnitButtons = VUHDO_GLOBAL["VUHDO_getUnitButtons"];
	VUHDO_IN_RAID_TARGET_BUTTONS = VUHDO_GLOBAL["VUHDO_IN_RAID_TARGET_BUTTONS"];
	VUHDO_PANEL_SETUP = VUHDO_GLOBAL["VUHDO_PANEL_SETUP"];
	VUHDO_BUTTON_CACHE = VUHDO_GLOBAL["VUHDO_BUTTON_CACHE"];

	VUHDO_getHealthBar = VUHDO_GLOBAL["VUHDO_getHealthBar"];
	VUHDO_isConfigDemoUsers = VUHDO_GLOBAL["VUHDO_isConfigDemoUsers"];
	VUHDO_updateBouquetsForEvent = VUHDO_GLOBAL["VUHDO_updateBouquetsForEvent"];
	VUHDO_isInFight = VUHDO_GLOBAL["VUHDO_isInFight"];
	sIsInverted = VUHDO_INDICATOR_CONFIG["CUSTOM"]["MANA_BAR"]["invertGrowth"];
end

----------------------------------------------------


--
local tInfo;
local tPowerType;
function VUHDO_updateManaBars(aUnit, aChange)
	tInfo = VUHDO_RAID[aUnit];
	if (tInfo == nil) then
		return;
	end

	if (tInfo["isVehicle"]) then
		if (tInfo["petUnit"] == nil) then
			return;
		end

		aUnit = tInfo["petUnit"];
		tInfo = VUHDO_RAID[aUnit];
		if (tInfo == nil) then
			return;
		end
	end

	if (not VUHDO_isConfigDemoUsers()) then
		if (aChange == 1) then
			tInfo["power"] = UnitMana(aUnit);
		elseif (aChange == 2) then
			tInfo["powermax"] = UnitManaMax(aUnit);
		elseif (aChange == 3) then
			tPowerType, _ = UnitPowerType(aUnit);
			tInfo["powertype"] = tonumber(tPowerType);
			tInfo["powermax"] = UnitManaMax(aUnit);
			tInfo["power"] = UnitMana(aUnit);
		end
	end

	if (tInfo["powertype"] == VUHDO_UNIT_POWER_MANA) then
		VUHDO_updateBouquetsForEvent(aUnit, VUHDO_UPDATE_MANA);

		if (aChange == 3) then
			VUHDO_updateBouquetsForEvent(aUnit, VUHDO_UPDATE_OTHER_POWERS);
		end
	else
		VUHDO_updateBouquetsForEvent(aUnit, VUHDO_UPDATE_OTHER_POWERS);

		if (aChange == 3) then
			VUHDO_updateBouquetsForEvent(aUnit, VUHDO_UPDATE_MANA);
		end
	end
end



--
local tAllButtons, tButton, tManaBar, tHealthBar, tQuota;
local tManaBarHeight;
function VUHDO_manaBarBouquetCallback(aUnit, anIsActive, anIcon, aCurrValue, aCounter, aMaxValue, aColor, aBuffName, aBouquetName)

	if (aMaxValue == nil or aCurrValue == nil) then
		anIsActive = false;
	end
	aMaxValue = aMaxValue or 0;
	aCurrValue = aCurrValue or 0;

	if (aMaxValue + aCurrValue == 0) then
		anIsActive = false;
	end

	tManaBarHeight = 0;
	tAllButtons =  VUHDO_getUnitButtons(aUnit);
	if (aCurrValue == 0 and aMaxValue == 0) then
		if (anIsActive) then
			tQuota = 100;
		else
			tQuota = 0;
		end
	elseif (aMaxValue > 1) then
		tQuota = 100 * aCurrValue / aMaxValue;
	else
		tQuota = 0;
	end

	if (tAllButtons ~= nil) then
		for _, tButton in pairs(tAllButtons) do
			if (anIsActive) then
				tManaBarHeight = VUHDO_PANEL_SETUP[VUHDO_BUTTON_CACHE[tButton]]["SCALING"]["manaBarHeight"];
			end
			tManaBar = VUHDO_getHealthBar(tButton, 2);
			if (tQuota > 0 and tManaBarHeight > 0) then
				if (aColor ~= nil) then
					tManaBar:SetStatusBarColor(aColor["R"], aColor["G"], aColor["B"], aColor["O"]);
				end
				tManaBar:SetValue(tQuota);
			else
				if (not anIsActive and sIsInverted) then
					tManaBar:SetValue(100);
				else
					tManaBar:SetValue(0);
				end
			end

			if (not VUHDO_isInFight()) then
				if (tManaBarHeight > 0) then
					tManaBar:SetHeight(tManaBarHeight);
				end
				VUHDO_getHealthBar(tButton, 1):SetHeight(tButton["regularHeight"] - tManaBarHeight);
			end
		end
	end

	if (VUHDO_RAID[aUnit] == nil) then
		return;
	end

	-- Targets und targets-of-target, die im Raid sind
  tAllButtons = VUHDO_IN_RAID_TARGET_BUTTONS[VUHDO_RAID[aUnit]["name"]];
	if (tAllButtons == nil) then
		return;
	end
	for _, tButton in pairs(tAllButtons) do
		tManaBar = VUHDO_getHealthBar(tButton, 2);
		if (tQuota > 0) then
			if (aColor ~= nil) then
				tManaBar:SetStatusBarColor(aColor["R"], aColor["G"], aColor["B"], aColor["O"]);
			end
			tManaBar:SetValue(tQuota);
		else
			tManaBar:SetValue(0);
		end
		if (not VUHDO_isInFight()) then
			tManaBarHeight = VUHDO_PANEL_SETUP[VUHDO_BUTTON_CACHE[tButton]]["SCALING"]["manaBarHeight"];
			tManaBar:SetHeight(tManaBarHeight);
			VUHDO_getHealthBar(tButton, 1):SetHeight(tButton["regularHeight"] - tManaBarHeight);
		end
	end
end
